--[[
 *
 * Copyright (c) 2015 - atom0s [atom0s@live.com]
 *
 * GDHook is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GDHook is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GDHook.  If not, see <http://www.gnu.org/licenses/>.
 *
]]--

---------------------------------------------------------------------------------------------------
-- desc: Main addon information. (These are required for your addon to load!)
---------------------------------------------------------------------------------------------------
_addon.author   = 'atom0s';
_addon.name     = 'fps';
_addon.version  = '1.0';

require 'common'

---------------------------------------------------------------------------------------------------
-- desc: Default FPS configuration table.
---------------------------------------------------------------------------------------------------
local default_config =
{
    font =
    {
        name        = 'Arial',
        size        = 12,
        color       = 0xFFFF0000,
        position    = { 1, 1 },
    },
    format = 'FPS: %.1f'
};
local fps_config = default_config;

---------------------------------------------------------------------------------------------------
-- desc: Main FPS table to hold useful variables.
---------------------------------------------------------------------------------------------------
local fps = { };
fps.count = 0;
fps.timer = 0;
fps.frame = 0;
fps.show  = true;

---------------------------------------------------------------------------------------------------
-- func: load
-- desc: The main event called when your addon is loaded.
---------------------------------------------------------------------------------------------------
hook.register_event('load', function()
    -- Attempt to load the fps configuration..
    fps_config = settings:load(_addon.path .. 'settings/fps.json') or default_config;
    fps_config = table.merge(default_config, fps_config);

    -- Create our font object..
    local f = HookCore:GetFontManager():CreateFontObject( '__fps_addon' );
    f:SetBold( false );
    f:SetColor( fps_config.font.color );
    f:SetFont( fps_config.font.name, fps_config.font.size );
    f:SetPosition( fps_config.font.position[1], fps_config.font.position[2] );
    f:SetText( '' );
    f:SetVisibility( fps.show );
end);

---------------------------------------------------------------------------------------------------
-- func: unload
-- desc: The event called when your addon is unloaded.
---------------------------------------------------------------------------------------------------
hook.register_event('unload', function()
    -- Save the configuration..
    local f = HookCore:GetFontManager():GetFontObject( '__fps_addon' );
    fps_config.font.position = { f:GetPositionX(), f:GetPositionY() };
    settings:save(_addon.path .. 'settings/fps.json', fps_config);
    
    -- Cleanup our font object..
    HookCore:GetFontManager():DeleteFontObject( '__fps_addon' );
end);

---------------------------------------------------------------------------------------------------
-- func: render
-- desc: The event called during 'EndScene' allowing our addon to render.
---------------------------------------------------------------------------------------------------
hook.register_event('render', function()
    local f = HookCore:GetFontManager():GetFontObject( '__fps_addon' );
    f:SetVisibility(fps.show);
    
    -- Don't continue if we have nothing to draw..
    if (fps.show == false) then
        return;
    end
    
    -- Calculate the frames..
    fps.count = fps.count + 1;
    if (os.time() >= (fps.timer + 1)) then
        fps.frame = fps.count;
        fps.count = 0;
        fps.timer = os.time();
    end
    
    f:SetText(string.format(fps_config.format, fps.frame));
end);
